include <BOSL2/std.scad>

// Inspired by https://www.youtube.com/watch?v=3V80-Fm_5Gs
// See http://iotic.com/flutomat/
// http://iotic.com/flutomat/#title=6-hole+D5&diamEmb=6.67&cents1=1200&diam1=7&cents2=1000&diam2=8.5&cents3=800&diam3=9&cents4=600&diam4=7&cents5=400&diam5=9&cents6=200&diam6=8&cents7=-498&diam7=5.5&cents8=-599&diam8=11.4561&cents9=-814&diam9=11.0976&cents10=-996&diam10=12.273&cents11=-1200&diam11=9.1133&cents12=-1302&diam12=12.7&cents13=-1509&diam13=0&cents14=NaN&diam14=0&cents15=NaN&diam15=0&cents16=NaN&diam16=0&cents17=NaN&diam17=0&cents18=NaN&diam18=0&cents19=NaN&diam19=0&cents20=NaN&diam20=0&cents21=NaN&diam21=0&cents22=NaN&diam22=0&cents23=NaN&diam23=0&cents24=NaN&diam24=0&cents25=NaN&diam25=0&cents26=NaN&diam26=0&cents27=NaN&diam27=0&cents28=NaN&diam28=0&cents29=NaN&diam29=0&cents30=NaN&diam30=0&cents31=NaN&diam31=0&cents32=NaN&diam32=0&cents33=NaN&diam33=0&cents34=NaN&diam34=0&cents35=NaN&diam35=0&cents36=NaN&diam36=0&cents37=NaN&diam37=0&cents38=NaN&diam38=0&cents39=NaN&diam39=0&cents40=NaN&diam40=0&cents41=NaN&diam41=0&cents42=NaN&diam42=0&cents43=NaN&diam43=0&cents44=NaN&diam44=0&cents45=NaN&diam45=0&cents46=NaN&diam46=0&cents47=NaN&diam47=0&cents48=NaN&diam48=0&cents49=NaN&diam49=0&cents50=NaN&diam50=0&cents51=NaN&diam51=0&cents52=NaN&diam52=0&cents53=NaN&diam53=0&cents54=NaN&diam54=0&cents55=NaN&diam55=0&cents56=NaN&diam56=0&cents57=NaN&diam57=0&cents58=NaN&diam58=0&cents59=NaN&diam59=0&cents60=NaN&diam60=0&cents61=NaN&diam61=0&cents62=NaN&diam62=0&cents63=NaN&diam63=0&cents64=NaN&diam64=0&cents65=NaN&diam65=0&cents66=NaN&diam66=0&cents67=NaN&diam67=0&cents68=NaN&diam68=0&cents69=NaN&diam69=0&cents70=NaN&diam70=0&cents71=NaN&diam71=0&cents72=NaN&diam72=0&cents73=NaN&diam73=0&cents74=NaN&diam74=0&cents75=NaN&diam75=0&cents76=NaN&diam76=0&cents77=NaN&diam77=0&cents78=NaN&diam78=0&cents79=NaN&diam79=0&cents80=NaN&diam80=0&cents81=NaN&diam81=0&cents82=NaN&diam82=0&cents83=NaN&diam83=0&cents84=NaN&diam84=0&cents85=NaN&diam85=0&cents86=NaN&diam86=0&cents87=NaN&diam87=0&cents88=NaN&diam88=0&cents89=NaN&diam89=0&cents90=NaN&diam90=0&cents91=NaN&diam91=0&cents92=NaN&diam92=0&cents93=NaN&diam93=0&cents94=NaN&diam94=0&cents95=NaN&diam95=0&cents96=NaN&diam96=0&cents97=NaN&diam97=0&cents98=NaN&diam98=0&cents99=NaN&diam99=0&centsEnd=0&cents100=NaN&fHoles=6&keyNote=74&keyFT=0&borD=16&walW=1.25&lipCov=0&unitMult=1.0&decPl=1&showSpc=0&showFreqs=0

// Params start
// Body
inside_diameter = 16; //mm
wall_thickness = 1.25; //mm
mouthpiece_length = 22; //mm
mouthpiece_angle = 45; //deg

// Tunings
edge_distance = 224;//mm distance from center of edge distance to end of flute
extra_tuning_length = 0; //mm
extra_tuning_diameter = 0; //mm

holes = [[7,159.4],[7.5,139.5],[8,117.3],[6.5,101.2],[9,71.5],[8,44.7]];//[diameter,distance_from_end_of_flute]

// Duct
edge_length = 5;//mm
duct_width=7;//mm
edge_angle=60;//deg
edge_fine_tune_x = 0.7; //mm until edge is continuous
edge_fine_tune_z = 1.3; //mm until the curve is gone from the cylinder
mouthpiece_external_cut_width=4;//mm
mouthpiece_external_cut_height=10;//mm

// Print
tolerance = 0.05; //mm
clip_plane_size = [100,100,100];//mm
resolution = 100;

//Calc
body_length=mouthpiece_length+edge_distance+edge_length/2+extra_tuning_length;

// Params end

top_edge_translate_coords = [-inside_diameter/2-wall_thickness+tolerance,-inside_diameter/2-wall_thickness+tolerance,body_length];

duct_ref_translate_coords = [top_edge_translate_coords.x,-duct_width/2,top_edge_translate_coords.z-mouthpiece_length-edge_length];

module clip_angle(){
    translate([-inside_diameter/2-wall_thickness*2,-inside_diameter/2-wall_thickness*2,body_length]) rotate([0,mouthpiece_angle,0])cube(clip_plane_size);}

difference(){
        cylinder(d=inside_diameter+wall_thickness*2-tolerance*2,h=body_length,$fn=resolution);
    cylinder(d=inside_diameter+tolerance*2,h=body_length,$fn=resolution);
    clip_angle();
    translate(duct_ref_translate_coords) cube([wall_thickness*2,duct_width,mouthpiece_length+edge_length]);
    
    translate([-inside_diameter/2+edge_fine_tune_x,duct_ref_translate_coords.y,duct_ref_translate_coords.z]) scale([-1,1,1]) rotate([0,edge_angle,0]) cube([wall_thickness*4,duct_width,mouthpiece_length+edge_length]);
    
    translate(duct_ref_translate_coords) translate([0,0,-edge_fine_tune_z]) cube([wall_thickness*2,duct_width,mouthpiece_length+edge_length]);
    
    // Holes 
    for (i = [0 : len(holes)-1]){
    translate([ 0, 0, extra_tuning_length+holes[i][1] ]) rotate([0,-90,0]) cylinder(d=holes[i][0]-extra_tuning_diameter,h=-top_edge_translate_coords.x,$fn=resolution);
    }
}